 ; Ŀ
 ;   Flat - move entities back to ground level.                            
 ;   Copyright 1993, 1999, 2006, 2009 by Rocket Software Ltd.              
 ;   There's no bottom in information space - you just keep falling.       
 ; 
 ; Ŀ
 ;   Note: if this routine is used on a Polyline it will move the entity   
 ;   down to ground level but the vertex definitions will claim to be      
 ;   untouched. If (entmod (subst (list 10 1 2 0) (10 3 4 1000) entt))     
 ;   the result will be (10 1 2 1000) - the X and Y are changed but not    
 ;   the Z.  Even modifying a single vertex with Chgx can't get around     
 ;   this. If, on the other hand, one performs the same operation on a     
 ;   polyline made with the 3dpoly command everything will work fine.      
 ;   Both entities are (0 . "POLYLINE"), although the 70 code for the 3D   
 ;   one is 8 as opposed to 0. If either is exploded after Flattening the  
 ;   resulting lines appear at zero elevation.  Inserts appear to move     
 ;   with no trouble.                                                      
 ;   If you flatten an entity whose extrusion direction is not parallel    
 ;   to the current ucs then bad things will happen - generally strange    
 ;   horizontal displacement.                                              
 ; 

 ; Ŀ
 ;   Subroutine Iron: does the actual work.                                
 ; 
 (DEFUN IRON (enam / entt sub asono gnent)
  (setq entt (entget enam))
  (while (setq sub (car entt))
         (setq entt (cdr entt))
         (if (member (setq asono (car sub)) '(10 11 12 13 14 15 16))
             (setq sub (list asono (cadr sub) (caddr sub) 0)))
         (setq gnent (cons sub gnent)))
  (entmod (reverse gnent)))
 ; Ŀ
 ;   Subroutine Iron end.                                                  
 ; 

 ; Ŀ
 ;   Flat - the CNS.  Decides what needs to be done and does it.  No       
 ;   messing around.  Not one of your wishy-washy programs.  We're         
 ;   talking a major improvement over programs with no clear idea of       
 ;   what to do (generally written for Windows).                           
 ; 
 (DEFUN C:FLAT ( / num ss len enam entt)
  (setvar "cmdecho" 0)
  (command "undo" "be")
  (setq num 0)
  (if (= 4 (logand 4 (getvar "cmdactive")))    ; during a script
      (setq ss (ssget "x"))
      (progn
           (write-line "Select entities: ")
           (setq ss (ssget))))
  (if ss
     (progn
          (setq len (strcat "/" (itoa (sslength ss))))
          (while (setq enam (ssname ss num))
                 (setq num (1+ num))
                 (grtext -2 (strcat (itoa num) len))
                 (setq entt (entget enam))
                 (if (setq asoc38 (assoc 38 entt))
                     (progn
                          (entmod (subst (cons 38 0) asoc38 entt))
                          (setq entt (entget enam))))
                 (if (assoc 66 entt)
                     (progn
                         (iron enam)
                         (while (/= (cdr (assoc 0 entt)) "SEQEND")
                                (setq entt (entget (setq enam (entnext enam))))
                                (iron enam)))
                     (iron enam)))))
  (if (/= (setq otis (getvar "elevation")) 0)
      (write-line (strcat "Caution: Elevation is currently set to "
                           (rtos otis 2 2))))
  (command "undo" "end")
 (PRINC))